<?php

namespace App\Http\Controllers;

use App\Models\HelpdeskTicketCategories;
use Illuminate\Http\Request;

class HelpdeskTicketCategoriesController extends Controller
{
    //
    public function index(HelpdeskTicketCategories $helpdeskTicketCategories ,Request $request)
    {
        $helpdeskTicketCategories = $helpdeskTicketCategories->latest();
        if($request->filled('pagination') || !empty($request->filters)){
            return $this->searchFilter($helpdeskTicketCategories, $request);
        }
        return $this->withCount($helpdeskTicketCategories, "Helpdesk Ticket Categories retrieved successfully.");
    }
    public function store(Request $request)
    {
       return $this->storeHelpdeskCategory($request);
    }
    public function show($category)
    {
       return $this->showHelpdeskCategory($category);
    }
    public function update(Request $request)
    {
       return $this->updateHelpdeskCategory($request);
    }
    public function destroy($category){
        return $this->destroyHelpdeskCategory($category);
    }
    
    
}
