<?php

namespace App\Http\Controllers;

use App\Models\HelpdeskTicket;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HelpdeskTicketController extends Controller
{

    public function index(HelpdeskTicket $helpdeskTicket, Request $request)
    {
        $helpdeskTicket = $helpdeskTicket->with('category', 'assigne_by:id,name', 'created_by:id,name');
        if ($request->has('search') && !empty($request->search)) {
            $searchTerm = $request->search;
            $helpdeskTicket->where(function ($q) use ($searchTerm) {
                $q->where('subject', 'like', '%' . $searchTerm . '%')
                    ->orWhere('description', 'like', '%' . $searchTerm . '%')
                    ->orWhere('name', 'like', '%' . $searchTerm . '%')
                    ->orWhere('ticket_id', 'like', '%' . $searchTerm . '%')
                    ->orWhere('email', 'like', '%' . $searchTerm . '%')
                    ->orWhereHas('created_by', function ($subquery) use ($searchTerm) {
                        $subquery->where(function ($nameQuery) use ($searchTerm) {
                            $nameQuery->where('name', 'like', '%' . $searchTerm . '%');
                        });
                    });
            });
        }
        $helpdeskTicket = $helpdeskTicket->latest()->get();
        return $this->withCount($helpdeskTicket, "Helpdesk Ticket retrieved successfully.");
    }

    public function showCustomerTickets(Request $request)
    {
        $user = Auth::user();
        $ticket = HelpdeskTicket::query();
        $ids = $this->getCustomerAndWorkspaceIds();
        
        // Determine which relation to load based on user type
        if ($ids['flag'] == 'customer') {
            // For customers, load user relation
            $ticket = $ticket->with(['created_by:id,name', 'category']);
        } else {
            // For employees, load employee relation
            $ticket = $ticket->with(['createdByEmployee', 'category']);
        }
        
        $ticket = $ticket->where(function ($query) use ($user) {
            $query->where('created_by', $user->id)
                ->orWhere('user_id', $user->id);
        });
        
        if ($request->has('search') && !empty($request->search)) {
            $searchTerm = $request->search;
            $ticket->where(function ($q) use ($searchTerm) {
                $q->where('subject', 'like', '%' . $searchTerm . '%')
                    ->orWhere('description', 'like', '%' . $searchTerm . '%')
                    ->orWhereHas('category', function ($subquery) use ($searchTerm) {
                        $subquery->where(function ($nameQuery) use ($searchTerm) {
                            $nameQuery->where('name', 'like', '%' . $searchTerm . '%');
                        });
                    });
            });
        }
        
        $ticket = $ticket->latest()->get();
        return $this->success($ticket, "Ticket list retrieved successfully.");
    }
    public function store(Request $request)
    {
        // dd($request->all());
        return $this->storeHelpdeskTicket($request);
    }
    public function show($category)
    {
        return $this->showHelpdesk($category);
    }
    public function update(Request $request)
    {
        return $this->updateHelpdesk($request);
    }
    public function destroy($category)
    {
        return $this->destroyHelpdesk($category);
    }

    public function reply(Request $request)
    {
        return $this->replyHelpdesk($request);
    }
    public function search(Request $request)
    {
        return $this->searchHelpdesk($request);
    }

    public function customerHelpdeskList()
    {
        return $this->getCustomerHelpdesk();
    }

    public function download($id)
    {
        // return $this->downloadFile('HelpdeskTicket', 'attachments', 5);
        return $this->downloadHelpdesk($id);
    }

    // public function exportCVS()
    // {
    //    // Retrieve data from the database
    //     $users = DB::table('users')->get();

    //     // Ensure there is data to export
    //     if ($users->isEmpty()) {
    //         return response()->json(['message' => 'No data available for export'], 404);
    //     }

    //     // Write data to CSV
    //     $csvFileName = 'user.csv';
    //     $csvFilePath = public_path($csvFileName); // Save in the public directory
    //     $csvFile = fopen($csvFilePath, 'w');

    //     // Get the column headers from the first row
    //     $headers = array_keys((array) $users[0]);
    //     fputcsv($csvFile, $headers);

    //     // Write each user's data to the CSV
    //     foreach ($users as $user) {
    //         fputcsv($csvFile, (array) $user);
    //     }

    //     fclose($csvFile);

    //     // Download the CSV file and delete it after sending
    //     return response()->download($csvFilePath)->deleteFileAfterSend(true);
    //  }




}
