<?php

namespace App\Http\Controllers;

use DB;
use App\Models\Role;
use App\Models\Tier;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\TierPermissions;
use Illuminate\Validation\Rule;
use App\Models\EmpCompanyDetails;
use App\Models\EmpPersonalDetails;
use App\Models\PermissionsModules;
use App\Models\PermissionsSubModules;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;



class RoleController extends Controller
{

    public function index(Request $request)
    {
        $query = Role::query();
        $query = $this->applyCustomerWorkspaceFilter($query);
        $roles =  $query->get();
        return $this->success($roles, 'Get Roles Successfully');
    }

    public function show($id)
    {

        $userTable = $this->getUserTable();
        $Role = Role::find($id);
        if (
            $userTable == "customer" && ($Role->workspace_id != auth()->user()->current_workspace_id || $Role->customer_id != auth()->user()->id)
        ) {
            return $this->message('You do not have access to this Role', 403);
        }

        if ($userTable == "emp" && ($Role->customer_id != auth()->user()->customer_id || $Role->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this Role', 403);
        }
        return $this->success($Role, 'Get Role Details Successfully');

    }

    public function role_edit(Request $request)
    {
      
        $id=$request->id;
        $userTable = $this->getUserTable();
        $Role = Role::find($id);
        if (
            $userTable == "customer" && ($Role->workspace_id != auth()->user()->current_workspace_id || $Role->customer_id != auth()->user()->id)
        ) {
            return $this->message('You do not have access to this Role', 403);
        }

        if ($userTable == "emp" && ($Role->customer_id != auth()->user()->customer_id || $Role->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this Role', 403);
        }
        return $this->success($Role, 'Get Role Details Successfully');
               
    }

    public function role_update(Request $request)
    {

        $user = auth()->user();
    
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'id' => 'required',
            'code' => 'required',
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
    
            return $this->error($error,422);
        }
        $id=$request->id;
        $validatedData = $validator->validated();
        $userTable = $this->getUserTable();
        $role = Role::where('id', $id)->first();
    
        if ($userTable == "customer" && ($role->workspace_id != auth()->user()->current_workspace_id || $role->customer_id != auth()->user()->id)
        ) {
            return $this->message('You do not have access to this role', 403);
        }

        if ($userTable == "emp" && ($role->customer_id != auth()->user()->customer_id || $role->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this role', 403);
        }
        if (!$role) {
            return $this->notFound('Role Not Found', 404);
        }
        
        $existingRole = Role::where('customer_id', $user->id)
                            ->where('workspace_id', $user->current_workspace_id)
                            ->where('code', $validatedData['code'])
                            ->where('id', '!=', $id) 
                            ->first();
    
        if ($existingRole) {

            return $this->message('This code is already taken for your customer account', 400);
        }
        $role->update($validatedData);
    
        if($userTable == "customer"){
            $data['roles'] = Role::where('customer_id', $user->id)
            ->where('workspace_id', $user->current_workspace_id)
            ->where('del', '0')
            ->get();
        }
        elseif($userTable == "emp"){
            $data['roles'] = Role::where('customer_id',auth()->user()->customer_id)
            ->where('workspace_id', auth()->user()->workspace_id)
            ->where('del', '0')
            ->get();
        }
        
        return $this->success($data, 'Role Updated Successfully');
    }
    


    public function store(Request $request)
    {
        $user = auth()->user();
        
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'code' => [
                'required',
                Rule::unique('roles')->where(function ($query) use ($user) {
                    return $query->where('customer_id', $user->id)
                                 ->where('workspace_id', $user->current_workspace_id);
                })
            ]
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return $this->error($error,422);

        } else {
            $validatedData = $validator->validated();
            $userTable = $this->getUserTable();
            $auth_id =0;
            $workspace_id = 0;
            if ($userTable === "customer") {
                $auth_id = Auth::user()->id;
                $workspace_id = Auth::user()->current_workspace_id;  
                $authPersonalDetails = User::where('id', Auth::user()->id)->first();
                
                
            }
            if ($userTable === "emp") {
                $auth_id = auth()->user()->customer_id;
                $workspace_id = auth()->user()->workspace_id;
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();  
            }
            $validatedData['customer_id'] = $auth_id;
            $validatedData['workspace_id'] = $workspace_id;
    
            Role::insert($validatedData);
            $data['roles'] = Role::where('customer_id', $auth_id)
                            ->where('workspace_id', $user->current_workspace_id)
                            ->where('del', '0') 
                            ->get();

                            return $this->success($data, 'Get Saved Successfully');
        }
    }
    


    public function role_delete(Request $request)
    {
        $id=$request->id;
        $role=Role::find($id);
        if (!$role) {
            return $this->message('Role not found', 404);
        }
        $userTable = $this->getUserTable();
        if ($userTable === "customer") {
            if ($role->customer_id !== auth()->id() || $role->workspace_id !== auth()->user()->current_workspace_id) {
                return $this->message('Unauthorized access', 403);
            }
        }
        if ($userTable === "emp") {
            if ($role->customer_id !== auth()->user()->customer_id || $role->workspace_id !== auth()->user()->workspace_id) {
                return $this->message('Unauthorized access', 403);
            }
        }
        if ($role->del == 1) {
            return $this->message('Role Already Deleted', 400);
        }
        $role->del = 1;
        if ($role->save()) {
            return $this->message('Role Deleted Successfully', 200);
        }
        return $this->message('Failed to Delete Role', 500);
    }


    
    public function tierRelatedData(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'tier_id' => 'required'
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return $this->error($error, 422);
        } else {
            $validatedData = $validator->validated();
            $userTable = $this->getUserTable();
            $auth_id = 0;
            $workspace_id = 0;
            if ($userTable === "customer") {
                $auth_id = Auth::user()->id;
                $workspace_id = Auth::user()->current_workspace_id;
                $authPersonalDetails = User::where('id', Auth::user()->id)->first();
            }
            if ($userTable === "emp") {
                $auth_id = auth()->user()->customer_id;
                $workspace_id = auth()->user()->workspace_id;
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
            }
    
            $tier = Tier::where('id', $validatedData['tier_id'])
                ->where('customer_id', $auth_id)
                ->where('workspace_id', $workspace_id)
                ->first();
            if (!$tier) return $this->error('Tier not found');
    
            $tierPermissions = TierPermissions::where('tier_id', $validatedData['tier_id'])
                ->where('del', '0')
                ->get();
    
            $modulePermissions = $tierPermissions->whereNull('sub_module_id')->groupBy('module_id')->toArray();
    
            $subModulePermissions = $tierPermissions->whereNotNull('sub_module_id');
            $permissionSubModuleIds = $subModulePermissions->pluck('sub_module_id')->unique()->toArray();
    
            $permissionSubModules = PermissionsSubModules::whereIn('id', $permissionSubModuleIds)
                ->where('del', '0')
                ->get();
    
            $moduleIds = $permissionSubModules->pluck('module_id')->unique()->toArray();
            $permissionModuleIds = $tierPermissions->pluck('module_id')->unique()->toArray();
            $allModuleIds = array_unique(array_merge($moduleIds, $permissionModuleIds));
    
            $permissionModules = PermissionsModules::whereIn('id', $allModuleIds)
                ->where('del', '0')
                ->get();
    
            $referenceModule = $permissionModules->first();
            $customer_id = $referenceModule->customer_id ?? $auth_id;
            $workspace_id = $referenceModule->workspace_id ?? $workspace_id;
    
            $allModules = PermissionsModules::where('del', '0')
                ->where(function ($query) use ($customer_id) {
                    $query->where('customer_id', $customer_id)
                        ->orWhereNull('customer_id');
                })
                ->where(function ($query) use ($workspace_id) {
                    $query->where('workspace_id', $workspace_id)
                        ->orWhereNull('workspace_id');
                })
                ->get();
    
            $allModuleIds = $allModules->pluck('id')->toArray();
            $allSubModules = PermissionsSubModules::whereIn('module_id', $allModuleIds)
                ->where('del', '0')
                ->get();
    
            // Group permissions by submodule ID
            $permissionsBySubModule = [];
            foreach ($subModulePermissions as $perm) {
                $subModId = $perm->sub_module_id;
                if (!isset($permissionsBySubModule[$subModId])) $permissionsBySubModule[$subModId] = [];
                $permissionsBySubModule[$subModId][] = $perm->toArray();
            }
    
            // Group submodules by module ID
            $subModulesByModule = [];
            foreach ($allSubModules as $subMod) {
                $modId = $subMod->module_id;
                if (!isset($subModulesByModule[$modId])) $subModulesByModule[$modId] = [];
    
                $subModData = $subMod->toArray();
                $subModData['permissions'] = $permissionsBySubModule[$subMod->id] ?? [];
                $subModulesByModule[$modId][] = $subModData;
            }
    
            $moduleData = [];
            foreach ($allModules as $mod) {
                $modInfo = $mod->toArray();
                
                // Add module-level permissions
                $modPermissions = collect($tierPermissions)
                    ->where('module_id', $mod->id)
                    ->whereNull('sub_module_id')
                    ->first();
                    
                $modInfo['view'] = $modPermissions ? $modPermissions->view : 0;
                $modInfo['maintain'] = $modPermissions ? $modPermissions->maintain : 0;
                $modInfo['sub_modules'] = $subModulesByModule[$mod->id] ?? [];
                $moduleData[] = $modInfo;
            }
    
            $data = ['tier' => $tier, 'modules' => $moduleData];

            if (empty($data['modules'])) {
                $allModules = PermissionsModules::where('del', '0')
                    ->where(function ($query) use ($auth_id) {
                        $query->where('customer_id', 11)
                            ->orWhereNull('customer_id');
                    })
                    ->where(function ($query) use ($workspace_id) {
                        $query->where('workspace_id', 1)
                            ->orWhereNull('workspace_id');
                    })
                    ->get();

                $allModuleIds = $allModules->pluck('id')->toArray();
                $allSubModules = PermissionsSubModules::whereIn('module_id', $allModuleIds)
                    ->where('del', '0')
                    ->get();

                $subModulesByModule = [];
                foreach ($allSubModules as $subMod) {
                    $modId = $subMod->module_id;
                    if (!isset($subModulesByModule[$modId])) $subModulesByModule[$modId] = [];

                    $subModData = $subMod->toArray();
                    $subModData['permissions'] = [];
                    $subModulesByModule[$modId][] = $subModData;
                }

                $defaultModuleData = [];
                foreach ($allModules as $mod) {
                    $modInfo = $mod->toArray();
                    $modInfo['view'] = 0;
                    $modInfo['maintain'] = 0;
                    $modInfo['sub_modules'] = $subModulesByModule[$mod->id] ?? [];
                    $defaultModuleData[] = $modInfo;
                }

                $data = ['tier' => $tier, 'modules' => $defaultModuleData];
            }

            return $this->success($data, 'Get Tier Related Data Successfully');
        }
    }

}
