<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Traits\SiteDiaryTrait;

class SiteDiaryController extends Controller
{
    use SiteDiaryTrait;

    /////////////////// Site Diary Management ///////////////////
    
    public function index(Request $request)
    {
        return $this->getSiteDiaries($request);
    }

    public function store(Request $request)
    {
        return $this->createSiteDiary($request);
    }

    public function show($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->getSiteDiaryById($id, $ids);
    }

    public function update(Request $request)
    {
        return $this->updateSiteDiary($request);
    }

    public function destroy($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->deleteSiteDiary($id, $ids);
    }

    /////////////////// Site Diary Management end ///////////////////

    public function deleteImage($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->deleteSiteDiaryImage($id, $ids);
    }

    public function toggleTask(Request $request)
    {
        return $this->toggleTaskStatus($request);
    }

    /**
     * Generate AI summary for site diary
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function generateSummary(Request $request)
    {
        return $this->generateAiSummary($request);
    }
}