<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\Training;
use DB;



class TrainingController extends Controller
{

    public function index(Request $request)
    {

        $data = Training::where('del', '0');
        $data = $this->applyCustomerWorkspaceFilter($data);
        if($request->filled('pagination') || !empty($request->filters)){
            $data = $this->searchFilterRecord( $data, $request);
        }else{
            $data = $data->orderBy('id', 'desc');
            $data = $data->get();
        }
        return $this->success($data, 'Get Trainings Successfully', 200);
    }

    public function show($id)
    {
        $training =  Training::find($id);
        if (!$training) {
            return $this->error('Training record not found', 404);
        }
        $ids = $this->getCustomerAndWorkspaceIds();
        if ($training->customer_id !== $ids['customer_id'] || $training->workspace_id !== $ids['workspace_id']) {
            return $this->error('You do not have access to this training record', 403);
        }
        return $this->success($training, 'Training record retrieved successfully');
    }

    public function edit($id)
    {
        $training = Training::find($id);
        if (!$training) {
            return $this->error('Training record not found', 404);
        }
        $ids = $this->getCustomerAndWorkspaceIds();
        if ($training->customer_id !== $ids['customer_id'] || $training->workspace_id !== $ids['workspace_id']) {
            return $this->error('You do not have access to this training record', 403);
        }
        return $this->success($training, 'Training record retrieved successfully');
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $ids = $this->getCustomerAndWorkspaceIds();
        $validatedData =  $validator->validated();
        $validatedData['customer_id'] = $ids['customer_id'];
        $validatedData['workspace_id'] = $ids['workspace_id'];
        $training = Training::find($id);
        if (!$training) {
            return $this->error('Training record not found', 404);
        }
        if ($training->customer_id !== $ids['customer_id'] || $training->workspace_id !== $ids['workspace_id']) {
            return $this->error('You do not have access to this training record', 403);
        }
        $training->update($validatedData);
        return $this->success('Training Updated Successfully', $training, 200);

    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData =  $validator->validated();
        $ids = $this->getCustomerAndWorkspaceIds();
        $validatedData['customer_id'] = $ids['customer_id'];
        $validatedData['workspace_id'] = $ids['workspace_id'];
        Training::insert($validatedData);
        $data['trainings'] = Training::where('del', '0')->get();
        return $this->success('Training Saved Successfully', $data, 200);
    }

    public function destroy($id)
    {
        $training = Training::find($id);
        $ids = $this->getCustomerAndWorkspaceIds();
        if ($training->customer_id !== $ids['customer_id'] || $training->workspace_id !== $ids['workspace_id']) {
            return $this->error('You do not have access to this training record', 403);
        }
        if (!$training) {
            return $this->message('Training not found.', 404);
        }
        $training->update(['del' => '1']);
        return $this->message('Training Deleted Successfully');
    }
}
