<?php

namespace App\Http\Controllers\Traits;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\ValidationTrait;
use App\Models\HelpdeskTicketCategories;


trait HelpDeskCategoryTrait{
    use ValidationTrait;
    public function storeHelpdeskCategory(Request $request)
    {
        $validator = $this->helpdeskCategoryValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData = $validator->validated();
        $category = HelpdeskTicketCategories::create($validatedData);
        if (!$category) {
            return $this->message('Failed to create Category.');
        }
        return $this->success($category, 'Category created successfully');
    }

    public function showHelpdeskCategory($category)
    {
        $category = HelpdeskTicketCategories::find($category);
        if (!$category) {
            return $this->message( 'Category not found');
        }
        return $this->success($category, 'Category retrieved successfully');
    }

    public function updateHelpdeskCategory($request)
    {   
        $validator = $this->helpdeskCategoryValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $category = HelpdeskTicketCategories::find($request->id);
        if (!$category) {
            return $this->message('Category not found');
        }
        $validationData = $validator->validated();
        $category->update($validationData);
        return $this->success($category , 'Category updated successfully');
    }

    protected function destroyHelpdeskCategory($category){
        $category = HelpdeskTicketCategories::find($category);
        if (!$category) {
            return $this->message('Category not found');
        }
        $category->delete();
        return $this->message('Category deleted successfully');
    }

    
    

}