<?php

namespace App\Http\Controllers\Traits;
use Illuminate\Http\Request;
use App\Models\module;


trait ModuleTrait {
    protected function storeModule(Request $request){
        $validator = $this->moduleValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validationData = $validator->validated();
        $slug = $this->createSlug($validationData['name']);
        if (Module::where('slug', $slug)->exists()) {
            return $this->message('The Module already exists');
        }
        $validationData['slug'] = $slug;
        // it can accept first request , directory name , and current image path if for delete image from directory 
        $image = $this->handleFileImageUpload($request, 'module');
        if($image){
            $validationData['image'] =$image['path'] ?? null;
        }
        $module = Module::create($validationData);

        return $this->success($module, 'Module successfully created.');
    }

    protected function showModule($module){
        $module = Module::find($module);
        if (!$module) {
            return $this->message('Module not found', 404);
        }
        return $this->success($module, 'Module retrieved successfully');

    }

    protected function updateModule($request){
        $module = Module::find($request->id);
        if (!$module) {
            return $this->message('Module not found.', 404);
        }
        $validator = $this->moduleValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validationData = $validator->validated();
        if ($module->name !== $validationData['name']) {
            $slug = $this->createSlug($validationData['name']);
            if (Module::where('slug', $slug)->where('id', '!=', $module->id)->exists()) {
                return $this->message('The Module already exists with this name.');
            }
            $validationData['slug'] = $slug;
        }
        // it can accept first request , directory name , and current image path if for delete image from directory 
        $image = $this->handleFileImageUpload($request, 'module', $module->image);
        if($image){
            $validationData['image'] = $image['path'] ?? null;
        }
        $module->update($validationData);
        return $this->success($module, 'Module successfully updated.');

    }
    protected function destroyModule($module){
        $module = Module::find($module);
        if (!$module) {
            return $this->message('Module not found', 404);
        }
        foreach ($module->subModules as $subModule) {
            // Delete the sub-module image if it exists
            if ($subModule->image && file_exists(public_path($subModule->image))) {
                unlink(public_path($subModule->image));
            }
            $subModule->delete();
        }
        $module->delete();
        return $this->message('Module and its sub-modules deleted successfully', 200);

}
}