<?php

namespace App\Http\Controllers\Traits;

use App\Models\module;
use Illuminate\Http\Request;
use App\Models\SubModule;


trait SubModuleTrait {

    protected function storeSubModule($request){
        $validator =$this->subModuleValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validationData = $validator->validated();
        $module = module::where('id', $validationData['module_id'])->first();
        if (!$module) {
            return $this->message('Module not found', 404);
        }
        $slug = $this->createSlug($validationData['name']);
        if (SubModule::where('slug', $slug)->exists()) {
            return $this->message('The Sub Module already exists');
        }
        $validationData['slug'] = $slug;
         // it can accept first request , directory name , and current image path if for delete image from directory 
         $image = $this->handleFileImageUpload($request, 'subModule');
         if($image){
             $validationData['image'] =$image['path'];
         }
         $subModule = SubModule::create($validationData);

        return $this->success($subModule, 'Sub Module successfully created.');

    }

    protected function showSubModule($subModule){
        $subModule = SubModule::find($subModule);
        if (!$subModule) {
            return $this->message('Sub Module not found', 404);
        }
        return $this->success($subModule, ' Sub Module retrieved successfully');
    }
    protected function updateSubModule($request){
        $subModule = SubModule::find($request->id);
        if (!$subModule) {
            return $this->message('Sub Module not found.', 404);
        }
        $validator =$this->subModuleValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validationData = $validator->validated();
        $module = module::where('id', $validationData['module_id'])->first();
        if (!$module) {
            return $this->message('Module not found', 404);
        }
        if ($subModule->name !== $validationData['name']) {
            $slug = $this->createSlug($validationData['name']);
            if (SubModule::where('slug', $slug)->where('id', '!=', $subModule->id)->exists()) {
                return $this->message('The Sub Module already exists with this name.');
            }
            $validationData['slug'] = $slug;
        }
        $image = $this->handleFileImageUpload($request, 'subModule', $subModule->image);
        if($image){
            $validationData['image'] = $image['path'];
        }
        $subModule->update($validationData);
        return $this->success($subModule, 'Sub Module successfully updated.');
    }

    protected function destroySubModule($subModule){
        $subModule = SubModule::find($subModule);
        if (!$subModule) {
            return $this->message('Sub Module not found', 404);
        }
        $subModule->delete();
        return $this->message('Sub Module deleted successfully', 200);
    }

}