<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Asset extends BaseModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'asset_name',
        'category',
        'model',
        'serial_number',
        'purchase_date',
        'purchase_price',
        'vendor',
        'warranty_expiry',
        'location',
        'assigned_to',
        'status',
        'description',
        'customer_id',
        'workspace_id',
        'site_id'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
 
    ];  

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'purchase_date' => 'date',
        'warranty_expiry' => 'date',
        'purchase_price' => 'decimal:2',
    ];

    /**
     * Get the customer that owns the asset.
     */
    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    /**
     * Get the workspace that owns the asset.
     */
    public function workspace()
    {
        return $this->belongsTo(Workspace::class, 'workspace_id');
    }

    /**
     * Get the site that owns the asset.
     */
    public function site()
    {
        return $this->belongsTo(Sites::class, 'site_id')->select('id', 'title' , 'description' , 'longitude', 'latitude', 'area_radius'); 
    }   

    public function employee_details()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'assigned_to', 'emp_id');
    }
}
