<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DynamicPages extends BaseModel
{
    use HasFactory;
    protected $table = 'pages';
    protected $fillable = [
        'title',
        'permalink',
        'main_heading',
        'long_description',
        'seo_title',
        'seo_tags',
        'seo_description',
        'canonical_url',
        'schema_markup',
        'page_index',
        'customer_id',
        'workspace_id',
        'short_description'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    protected $casts = [
        'page_index' => 'boolean',
    ];
}
