<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Illuminate\Database\Eloquent\Model;
use App\Scopes\NotDeletedScope;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use App\Models\Traits\AuthenticatableTrait;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Traits\HelperTrait;


class EmpCompanyDetails extends BaseModel implements AuthenticatableContract
{
    use HasApiTokens, HasFactory, Notifiable, AuthenticatableTrait;
    use HelperTrait;
    protected $table = 'emp_company_details';
    protected $fillable = ['employee_email','employment_type','access_role','work_permit_type','tax_file_no','tier_id','employment_start_date','employment_end_date',
                                'attendance_effective_from','status','invited','password','approved','approved_by','approved_at','created_by','is_submitted','compeleted',
                                'rejected','force_reset' , 'customer_id' , 'workspace_id','link_key'];

    
    // Add this for Passport to work correctly
    protected $guard = 'api';

    // Make sure password is hidden
    protected $hidden = [
        'password',
        'remember_token',
        'customer_id',
        'workspace_id',
    ];


    // protected $appends = ['user_type'];

    protected static function booted()
    {
        static::addGlobalScope(new NotDeletedScope);
    }

    // // 👇 Accessor to return fixed value
    // public function getUserTypeAttribute()
    // {
    //     return 3;
    // }

    public function findForPassport($username)
    {
        return $this->where('employee_email', $username)->first();
    }
    
    
    public function empPersonalDetails()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'id');
    }

    public function accessRole()
    {
        $userTable = $this->getUserTable();
        $auth_id = 0;
        $workspace_id = 0;
        if ($userTable === "customer") {
            $auth_id = Auth::user()->id;
            $workspace_id = Auth::user()->current_workspace_id;
        }
        if ($userTable === "emp") {
            $auth_id = auth()->user()->customer_id;
            $workspace_id = auth()->user()->workspace_id;
        }
        return $this->hasOne(Role::class, 'code', 'access_role')->where('customer_id', $auth_id)->where('workspace_id', $workspace_id);
    }
    public function accessTier()
    {
        return $this->hasOne(Tier::class, 'id', 'tier_id');
    }
    public function workerType()
    {
        return $this->hasOne(EmpWorkerType::class, 'id', 'worker_type');
    }

    public function empworkExperience()
    {
        return $this->hasOne(EmpWorkExperience::class, 'id', 'emp_work_experience');
    }

    public function tierEmpPersonalDetail()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'id')->select('emp_id','image');
    }

    public function empAccess()
    {
        return $this->hasOne(EmpAccess::class, 'emp_id', 'id');
    }

    public function empTier()
    {
        return $this->hasOne(Tier::class, 'id', 'tier_id');
    }

    public function empEmergencyContacts()
    {
        return $this->hasMany(EmpEmergencyContacts::class, 'emp_id', 'id');
    }

    public function empDocuments()
    {
        return $this->hasMany(EmpDocuments::class, 'emp_id', 'id');
    }

    public function empTeamsMembers()
    {
        return $this->hasMany(EmpTeamsMember::class, 'emp_id', 'id')->with('empTeamsList');
    }

    public function rosterAssign()
    {
        return $this->hasOne(RosterAssign::class, 'assign_to', 'id');
    }

    public function empMetaData()
    {
        return $this->hasMany(UserMeta::class, 'emp_id', 'id');
    }
    public function funds_meta()
    {
        return $this->hasMany(FundsMeta::class, 'emp_id', 'id');
    }

    public function overtime()
    {
        return $this->hasMany(Overtime::class, 'employee_id', 'id');
    }

}


