<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fine extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'date',
        'fine_amount',
        'fine_reason',
        'type', // 0 = Fine, 1 = Bonus
        'customer_id',
        'workspace_id',
        'created_by',
    ];

    protected $casts = [
        'fine_amount' => 'decimal:2',
        'type' => 'integer',
    ];
    
    // Note: Removed 'date' => 'date' cast to prevent Carbon::parse errors
    // Date formatting is now handled by BaseModel's date parsing logic

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }

    public function employeeCom()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id', 'id');
    }

    public function createdBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'created_by', 'emp_id');
    }

    // Scopes
    public function scopeFines($query)
    {
        return $query->where('type', 0);
    }

    public function scopeBonuses($query)
    {
        return $query->where('type', 1);
    }
} 