<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentDocument extends BaseModel
{
    use HasFactory;
    // Define table name explicitly
    protected $table = 'incident_documents';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'title',
        'number'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }
}
