<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentEmployeeInjuryType extends BaseModel
{
    use HasFactory;
    protected $table = 'incident_employee_injury_types';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'employer_id',
        'option',
        'value'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function employer()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employer_id');
    }
}
