<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentInvolvedPersonDetail extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_involved_person_details';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'employee_id',
        'surname',
        'contact_number',
        'gender',
        'dob',
        'age',
        'occupation',
        'language',
        'experience_years',
        'experience_months',
        'employment_type',
        'employee_type',
        'shift_type',
        'shift_time',
        'is_type_emp',
        'is_inj_detail',
    ];
    protected $casts = [
        'employment_type' => 'integer',
    ];
    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }

    public function employmentType()
    {
        return $this->belongsTo(EmpType::class, 'employment_type', 'id'); // Ensure proper column mapping
    }

    public function empCompanyDetails()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id', 'id');
    }
}
