<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentNotifiedTo extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_notified_tos';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'notified_to',
        'ohs_regulator',
        'reference_number',
        'date',
        'time',
        'contact_name'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function notifiedPerson()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'notified_to');
    }
}
