<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportQuestion extends BaseModel
{
    use HasFactory;

    protected $fillable = ['question', 'description', 'status' , 'customer_id' , 'workspace_id'];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function answer()
    {
        return $this->hasOne(IncidentReportQuestionAnswer::class, 'question_id');
    }
    
}
