<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportQuestionAnswer extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_report_question_answers';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'question_id',
        'answer'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function question()
    {
        return $this->belongsTo(IncidentReportQuestion::class, 'question_id');
    }
}
