<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentRiskCategory extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'status',
        'del',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    // Define relationships
    public function answers()
    {
        return $this->hasMany(IncidentReportQuestionAnswer::class, 'question_id');
    }
}
