<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentWitnes extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_witness';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'name',
        'date',
        'time',
        'statement_number'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }
}
