<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionPlan extends BaseModel
{
    use HasFactory;
    protected $guarded = [];

    protected $fillable = [
        'title',
        'customer_id',
        'workspace_id',
        'itp_reference_number',
        'document_number',
        'authorised_by',
        'site_id',
        'revision_number',
        'revision_date',
        'issue_date',
        'principal_contractor',
        'project_name',
        'job_number',
        'building',
        'level',
        'to_level',
        'zone',
        'pour',
        'activity',
        'open_date',
        'close_date',   
        'del',
        'process',
        'description',
        'is_published',
        'parent_number',
        'principal_contractor_email',
        'report_method'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function authorizedBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'authorised_by', 'emp_id');
    }
    public function siteData()
    {
        return $this->belongsTo(Sites::class, 'site_id', 'id');
    }
    public function site()
    {
        return $this->belongsTo(Sites::class, 'site_id', 'id');
    }
    
    public function checklists()
    {
        return $this->hasMany(InspectionPlanChecklist::class, 'inspection_plan_id', 'id');
    }
    
    public function metas()
    {
        return $this->hasMany(InspectionPlanMeta::class, 'inspection_plan_id', 'id');
    }
}