<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionPlanSignature extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'inspection_plan_id',
        'itpc_id',
        'employee_id',
        'is_site_employee',
        'employee_name',
        'employee_type',
        'signature',
        'date',
        'time',
        'del',
        'signature_type'
    ];

    public function employeeDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }
}
