<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lead extends BaseModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'contact_number',
        'review',
        'referral_id',
    ];

    /**
     * Get the referral that owns the lead.
     */
    public function referral()
    {
        return $this->belongsTo(Referral::class);
    }
} 