<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeavePackage extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'title',
        'leave_type_id',
        'leave_number',
        'is_paid',
        'color_code',
        'renew_on',
        'workspace_id',
        'customer_id',
        'employee_roles'
        ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }
}
