<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LinkManagement extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'role_id',
        'tier_id',
        'created_by',
        'title',
        'description',
        'status',
        'working_days',
        'number_of_days',
        'start_time',
        'end_time',
        'paid_break',
        'color_code',
        'secret_key',
        'workspace_id',
        'customer_id',
        'team_ids',
        'name',
        'email',
        'phone',
        'address',
        'company_name',
        'company_logo',
        'required_hours',
        'site_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];


    public function tierId()
    {
        return $this->hasOne(Tier::class, 'id', 'tier_id')->select('id', 'title' , 'tier_key');
    }


    public function roleId()
    {
        return $this->hasOne(Role::class, 'id', 'role_id')->select('id', 'title' , 'code');
    }
}
