<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Meeting extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        
        'created_by',
        'site_id',
        'agenda',
        'description',
        'status',
        'start_date',
        'end_date',
        'start_time',
        'end_time',
        'is_recurring',
        'allow_meeting_members',
        'frequency',
        'days',
        'allow_guest',
        'is_deleted',
        'is_before_meeting',
        'notes',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    

    public function meeting_users()
    {
        return $this->hasMany(MeetingUser::class)->with('meeting_employees','meeting_attendances');
    }

    public function meeting_organisers()
    {
        return $this->hasMany(MeetingOrganiser::class)->with('organiser');
    }

    public function created_by()
    {
        return $this->hasOne(EmpPersonalDetails::class,'emp_id','created_by')->select('id','emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting_site()
    {
        return $this->hasOne(Sites::class,'id','site_id')->select('id','title');
    }

    public function meeting_documents()
    {
        return $this->hasMany(MeetingDocument::class)
        ->with('employee_signed_document.employee');
    }
    public function meeting_note_documents_pdf()
    {
        return $this->hasMany(MeetingNoteDocumentsPdf::class);
    }

    public function meeting_note_documents(){
        return $this->hasMany(MeetingDocumentNote::class)->with('meeting_note_signatures');
    }
    public function meeting_histories(){
        return $this->hasMany(MeetingHistory::class);
    }

    public function today_meeting_documents()
    {
        $today = date('Y-m-d');
        return $this->hasMany(MeetingDocument::class)
            ->where(function($query) use ($today) {
                $query->where('is_daily', 1)  // Show daily documents every day
                      ->orWhere('meeting_date', $today)  // Show specific date documents only on that date
                      ->orWhere(function($q) use ($today) {
                          $q->whereNull('meeting_date')  // Legacy documents without meeting_date
                            ->where('is_daily', 0);  // and not marked as daily
                      });
            });
    }
    public function meeting_guest_users()
    {
        return $this->hasMany(MeetingGuestUser::class);
    }
    public function meeting_documents_only()
    {
        return $this->hasMany(MeetingDocument::class);
    }
    public function today_meeting_document_notes()
    {
        $today = date('Y-m-d');
        return $this->hasMany(MeetingDocumentNote::class,'meeting_id','id')
                    ->where(function($query) use ($today) {
                        $query->whereNull('day_of_the_week')
                              ->orWhere('day_of_the_week', '')
                              ->orWhere('day_of_the_week', $today);
                    })
                    ->with('meeting_note_documents_pdf');
    }
}
