<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingNoteSignature extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'meeting_id',
        'employee_id',
        'employee_note_id',
        'signature',
        'date',
        'del',
    ];

    public function employee()
    {
        return $this->hasOne(EmpPersonalDetails::class,'emp_id','employee_id')->select('id','emp_id','first_name','middle_name','last_name','image');
    }
    public function meeting()
    {
        return $this->hasOne(Meeting::class,'id','meeting_id');
    }
}
