<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends BaseModel
{
    use HasFactory;
    protected $table = "all_notifications";

    protected $fillable = [
        'title',
        'short_description',
        'sender_id',
        'sender_type',
        'receiver_id',
        'receiver_type',
        'type',
        'read',
        'customer_id',
        'workspace_id'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function senderDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'sender_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }

    public function receiverDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'receiver_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }
    // abc
    public function sites()
    {
        return $this->belongsTo(Sites::class,'site_id')->select('id','title');
    }

    public function teams()
    {
        return $this->belongsTo(EmpTeam::class,'team_id')->select('id','title');
    }
}
