<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'client_id',
        'thumbnail',
        'description',
        'address',
        'longitude',
        'latitude',
        'area_radius',
        'state',
        'customer_id',
        'workspace_id',
        'created_by',
        'end_date',
        'start_date',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function projectDocuments()
    {
        return $this->hasMany(ProjectDocument::class);
    }
    public function projectMeta()
    {
        return $this->hasOne(ProjectMeta::class);
    }
        public function site()
    {
        return $this->hasMany(ProjectSite::class, 'project_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'client_id');
    }
}
