<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralLead extends Model
{
    use HasFactory;

    protected $fillable = [
        'referral_user_id',
        'customer_id',
        'email',
        'name',
        'phone',
        'status',
        'referral_code',
        'converted_at',
        'meta_data',
    ];

    protected $casts = [
        'converted_at' => 'datetime',
        'meta_data' => 'array',
    ];

    public function referralUser()
    {
        return $this->belongsTo(User::class, 'referral_user_id');
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function markAsConverted($customerId)
    {
        $this->update([
            'customer_id' => $customerId,
            'status' => 'converted',
            'converted_at' => now(),
        ]);
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeConverted($query)
    {
        return $query->where('status', 'converted');
    }
}
