<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteSafetyAudit extends BaseModel
{
    use HasFactory;
    protected $guarded=[];
    public function ClosedBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'closed_by', 'emp_id');
    }
    public function SiteData()
    {
        return $this->belongsTo(Sites::class, 'site_id', 'id');
    }
    public function safetyAuditDetails()
    {
        return $this->hasMany(SafetyAuditDetails::class, 'safety_audit_id');
    }

    public function safetyAuditReportImages()
    {
        return $this->hasMany(SafetyAuditReportImage::class, 'safety_audit_id');
    }
}
