<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SwmsApprovedBy extends BaseModel
{
    use HasFactory;
    protected $table = 'swms_approved_bies'; // Explicitly defining table name

    protected $fillable = [
        'swms_id',
        'signature',
        'employee_id',
        'date',
        'del', // Enum (0,1) - Default 0
    ];

    // Define relationships
    public function swms()
    {
        return $this->belongsTo(Swms::class, 'swms_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id' ,'emp_id');
    }
}
