<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SwmsAwnswers extends BaseModel
{
    use HasFactory;
    protected $guarded = [];
    protected $casts = [
        'swms_question_id' => 'integer',
    ];

    protected $fillable = [
        'swms_id',
        'swms_question_id',
        'answer',
    ];

    // Relationship with the Swms model
    public function swms()
    {
        return $this->belongsTo(Swms::class, 'swms_id');
    }

    // Relationship with the SwmsQuestion model
    public function swmsQuestion()
    {
        return $this->belongsTo(SwmsQuestions::class, 'swms_question_id');
    }
}
 