<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SwmsSignature extends BaseModel
{
    use HasFactory;
    protected $guarded = [];
    protected $casts = [
        'swms_id' => 'integer',
    ];
    protected $fillable = [
        'swms_id',
        'emp_id',
        'is_site_employee',
        'signatures',
        'job_desription',  // **(Fix: Spelling mistake in migration)**
        'inductance_date',
    ];

    // Define relationships
    public function swms()
    {
        return $this->belongsTo(Swms::class, 'swms_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'emp_id');
    }
    public function empPersonalDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'emp_id', 'emp_id');
    }
}
