<?php
// App/Models/WHSQE_TableOfContentChild.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WHSQE_TableOfContentChild extends BaseModel
{
    protected $fillable = ['title', 'whsqe_table_of_content_id', 'del','customer_id','workspace_id'];
    protected $table = 'whsqe_table_of_content_child';

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function parent()
    {
        return $this->belongsTo(WHSQE_TableOfContent::class, 'whsqe_table_of_content_id');
    }
    
    public function grandchildren()
    {
        return $this->hasMany(WHSQE_TableOfContentGrandChild::class, 'whsqe_table_of_content_child_id');
    }
}