<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WhsSignature extends BaseModel
{
    use HasFactory;

    protected $table = 'whs_signatures'; // Explicit table name

    protected $fillable = [
        'whs_id',
        'employee_id',
        'is_site_employee',
        'signatures',
        'job_desription',
        'inductance_date',
    ];

    /**
     * Define relationships
     */
    public function whs()
    {
        return $this->belongsTo(WhsReport::class, 'whs_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id' , 'emp_id');
    }
}
