<?php

return [
    'meeting_recurring' => [
        'one_time' => ['key' => 0, 'value' => 'One Time'],
        'recurring' => ['key' => 1, 'value' => 'Recurring'],
    ],
    'meeting_frequency' => [
        'daily' => ['key' => 1, 'value' => 'Daily'],
        'weekly' => ['key' => 2, 'value' => 'Weekly'],
        'monthly' => ['key' => 3, 'value' => 'Monthly'],
        'custom' => ['key' => 4, 'value' => 'Custom']
    ],
    'weekdays' => [
        'monday' => '1',
        'tuesday' => '2',
        'wednesday' => '3',
        'thursday' => '4',
        'friday' => '5',
        'saturday' => '6',
        'sunday' => '7',
    ],
    'meeting_status' => [
        'pending' => ['key' => 0, 'value' => 'Pending'],
        'completed' => ['key' => 1, 'value' => 'Completed'],
        'cancelled' => ['key' => 2, 'value' => 'Cancelled'],
        'expired' => ['key' => 3, 'value' => 'Expired']
    ],
    'allow_meeting_members' => [
        'everyone' => ['key' => 0, 'value' => 'Everyone'],
        'specific' => ['key' => 1, 'value' => 'Specific']
    ],
    'roles' => [
        'safety_manager' => ['key' => '01', 'value' => 'Safety Manager'],
        'safety_officer_sso' => ['key' => 'SSO', 'value' => 'Safety Officer SSO'],
        'foreman_fm' => ['key' => 'FM', 'value' => 'Foreman FM'],
        'director' => ['key' => 'Dir', 'value' => 'Director']
    ],


    // SWMS
    'review_frequency' => [
        'Monthly',
        '3 Monthly',
    ],
    'injury_types' => [
        ['key' => 0, 'value' => 'NATURE OF INJURY'],
        ['key' => 1, 'value' => 'BODILY LOCATION OF INJURY/DISEASE'],
        ['key' => 2, 'value' => 'NATURE OF DISEASE'],
        ['key' => 3, 'value' => 'MECHANISM OF INJURY/DISEASE'],
        ['key' => 5, 'value' => 'BREAKDOWN AGENCY/AND AGENCY OF INJURY/DISEASE']
    ],
    'weekdays_name' => [
        'Monday' => 'Mon',
        'Tuesday' => 'Tue',
        'Wednesday' => 'Wed',
        'Thursday' => 'Thu',
        'Friday' => 'Fri',
        'Saturday' => 'Sat',
        'Sunday' => 'Sun',
    ],
    'metting_types' => [
        'Prestart' => 'pre',
        'Toolbox' => 'tool',
        
    ],
    'user_types' => [
        'admin' => 1,
        'customer' => 2,
        'employee' => 3,
        'referral' => 4,
    ],
    'custom_domain_status' => [
        'pandding' => 0,
        'approve' => 1,
        'reject' => 2,
    ],
    'login_customer' => [
        'enable' => 1,
        'disabled' => 0,
    ],
    'user_status' => [
        'active' => 1,
        'inactive' => 0,
    ],
    'user_deleted' => [
        'del_true' => 1,
        'del_false' => 0,
    ],
    'payment_types' => [
        'bank' => 1,
        'pay_pal' => 2,
        'stripe' => 3,

    ],

    'stripe_mode' => env('STRIPE_MODE' , 'live'), // 'sandbox' or 'live'
    'stripe_sandbox_key' => env('STRIPE_SANDBOX_KEY', 'sk_test_51RPHefQ3Ybzz50vCT8nT9tkOoreH0bxj6EJvXOI8ktUXcKLw7OlECXwl3NwYFykyhS7cl1KMDuswn7UlwhA5eEEt00YpMHda4T'),
    'stripe_live_key' => env('STRIPE_LIVE_KEY', ''),
    'stripe_webhook_secret' => env('STRIPE_WEBHOOK_SECRET', 'whsec_d3b9a7289c08c7bf5a19142edb870f5014646aceb282b6142dd82285f57f4447'),

    'payment_statuses' => [
        'pending' => 0,
        'completed' => 1,
        'failed' => 2,
        'refunded' => 3,
        'rejected' => 4,
    ],
    
    'subscription_status' => [
        'active' => 'active',
        'trialing' => 'trialing',
        'past_due' => 'past_due',
        'canceled' => 'canceled',
        'unpaid' => 'unpaid',
        'incomplete' => 'incomplete',
        'incomplete_expired' => 'incomplete_expired',
    ],
    'keys' => [
        'brand_logo_dark',
        'brand_favicon',
        'brand_title_text',
        'brand_footer_text',
        
        'company_company_name',
        'company_company_address',
        'company_company_city',
        'company_company_post_code',
        'company_company_state',
        'company_company_country',
        'company_company_telephone',
        'company_company_email',
        'company_company_crn',
        'company_company_se',
        
        'system_date_format',
        'system_time_format',
        'bank_detail_name',
        'bank_detail_account_name',
        'bank_detail_account_number',
        'system_menu_type',
        'sidebar_brand_logo',
    ],

    // Late Fine Configuration
    'late_fine_config' => [
        'fine_start_time' => '08:16',
        'fine_tiers' => [
            'tier_1' => [
                'end_time' => '08:30',
                'percentage' => 10,
                'description' => 'First tier fine'
            ],
            'tier_2' => [
                'end_time' => '09:00',
                'percentage' => 20,
                'description' => 'Second tier fine'
            ],
            'tier_3' => [
                'end_time' => null, // No end time means any time after tier_2
                'percentage' => 30,
                'description' => 'Third tier fine'
            ]
        ]
    ],

    // Overtime Status Configuration
    'overtime_status' => [
        'pending' => 'pending',
        'approved' => 'approved',
        'rejected' => 'rejected',
    ],
    'employee_types' => [
        'employee' => 'emp',
        'customer' => 'customer',
        'admin' => 'admin',
    ],

    // Notification Types Configuration
    'notification_types' => [
        'overtime_applied' => 'overtime_applied',
        'overtime_approved' => 'overtime_approved',
        'overtime_rejected' => 'overtime_rejected',
        'signature_added' => 'signature_added',
        'report_approved' => 'report_approved',
        'report_pdf_uploaded' => 'report_pdf_uploaded',
        'report_approval_needed' => 'report_approval_needed',
        'customer_signup' => 'customer_signup',
        'leave_request_submitted' => 'leave_request_submitted',
        'leave_request_pending_approval' => 'leave_request_pending_approval',
        'leave_request_notification' => 'leave_request_notification',
        'leave_request_customer_notification' => 'leave_request_customer_notification',
        'leave_request_approved' => 'leave_request_approved',
        'leave_request_rejected' => 'leave_request_rejected',
        'meeting_created' => 'meeting_created',
        'meeting_invitation' => 'meeting_invitation',
        'password_reset' => 'password_reset',
        'custom' => 'custom',
        'referral_signup' => 'referral_signup',
        'referral_code_generated' => 'referral_code_generated',
        'referral_approved' => 'referral_approved',
        'referral_rejected' => 'referral_rejected',
        'referral_payout_requested' => 'referral_payout_requested',
        'commission_approved' => 'commission_approved',
        'commission_rejected' => 'commission_rejected',
        'payout_approved' => 'payout_approved',
        'payout_rejected' => 'payout_rejected',

    ],
    'superadmin' =>11,
    'frontend' => [
        'url' => 'https://staging.workforcems.com.au',
    ],
    
    'whsq_content_settings_type' => [
        'parent' => 'WHSQE_TableOfContent',
        'child' => 'WHSQE_TableOfContentChild',
        'grandchild' => 'WHSQE_TableOfContentGrandChild',
    ],

    // Defect Status Configuration
    'defect_status' => [
        'open' => ['key' => 0, 'value' => 'Open'],
        'in_progress' => ['key' => 1, 'value' => 'In Progress'],
        'submitted' => ['key' => 2, 'value' => 'Submitted'],
        'completed' => ['key' => 3, 'value' => 'Completed'],
        'approved' => ['key' => 4, 'value' => 'Approved'],
        'rejected' => ['key' => 5, 'value' => 'Rejected'],
        'reassigned' => ['key' => 6, 'value' => 'Reassigned'],
    ],

    // Defect Priority Configuration
    'defect_priority' => [
        'low' => ['key' => 'low', 'value' => 'Low'],
        'medium' => ['key' => 'medium', 'value' => 'Medium'],
        'high' => ['key' => 'high', 'value' => 'High'],
        'critical' => ['key' => 'critical', 'value' => 'Critical'],
    ],

    'chat_gpt_api_key' => env('CHAT_GPT_API_KEY', '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'),

   
 
];
