<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Webhook Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration for webhook authentication and
    | security settings for external API access to orders.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Default Webhook Credentials
    |--------------------------------------------------------------------------
    |
    | Default API key, webhook URL, and secret for webhook access.
    | These are static values that can be used for testing or default access.
    |
    */
    'default' => [
        'api_key' => env('WEBHOOK_DEFAULT_API_KEY', 'wms-default-api-key-2025'),
        'webhook_url' => env('WEBHOOK_DEFAULT_URL', 'https://your-domain.com/webhook'),
        'webhook_secret' => env('WEBHOOK_DEFAULT_SECRET', 'wms-webhook-secret-2025'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Webhook Secrets
    |--------------------------------------------------------------------------
    |
    | Array of hashed webhook secrets that are allowed to access the webhook
    | endpoints. These should be generated using Laravel's Hash facade.
    |
    | To generate a new secret:
    | php artisan tinker
    | Hash::make('your-secret-key')
    |
    */
    'secrets' => [
        // Default webhook secret (hashed)
        '$2y$10$z0qwHFl2dx3DOFd8W8ie4eFMHk.Aj8dx9gS4sqTXmwSytnEBBtPHa', // This is Hash::make('wms-webhook-secret-2025')
        
        // Additional webhook secrets from environment
        env('WEBHOOK_SECRET_1'),
        env('WEBHOOK_SECRET_2'),
        env('WEBHOOK_SECRET_3'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Allowed Webhook URLs
    |--------------------------------------------------------------------------
    |
    | Array of URLs that are allowed to make webhook requests. This provides
    | an additional layer of security by validating the source URL.
    |
    | Leave empty to allow requests from any URL (not recommended for production)
    |
    */
    'allowed_urls' => [
        // Default webhook URL
        env('WEBHOOK_DEFAULT_URL', 'https://your-domain.com/webhook'),
        'http://127.0.0.1:8001/api/webhook',
        
        // Additional allowed webhook URLs
        env('WEBHOOK_URL_1'),
        env('WEBHOOK_URL_2'),
        env('WEBHOOK_URL_3'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Rate Limiting
    |--------------------------------------------------------------------------
    |
    | Configure rate limiting for webhook endpoints to prevent abuse.
    |
    */
    'rate_limit' => [
        'enabled' => env('WEBHOOK_RATE_LIMIT_ENABLED', true),
        'max_attempts' => env('WEBHOOK_RATE_LIMIT_ATTEMPTS', 100),
        'decay_minutes' => env('WEBHOOK_RATE_LIMIT_DECAY', 60),
    ],

    /*
    |--------------------------------------------------------------------------
    | Logging Configuration
    |--------------------------------------------------------------------------
    |
    | Configure webhook request logging for security and debugging.
    |
    */
    'logging' => [
        'enabled' => env('WEBHOOK_LOGGING_ENABLED', true),
        'log_successful_requests' => env('WEBHOOK_LOG_SUCCESS', true),
        'log_failed_requests' => env('WEBHOOK_LOG_FAILURES', true),
        'log_request_body' => env('WEBHOOK_LOG_BODY', false), // Be careful with sensitive data
    ],

    /*
    |--------------------------------------------------------------------------
    | IP Whitelist
    |--------------------------------------------------------------------------
    |
    | Array of IP addresses that are allowed to make webhook requests.
    | Leave empty to allow requests from any IP.
    |
    */
    'allowed_ips' => [
        // Add your allowed IP addresses here
        env('WEBHOOK_IP_1'),
        env('WEBHOOK_IP_2'),
        env('WEBHOOK_IP_3'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Response Configuration
    |--------------------------------------------------------------------------
    |
    | Configure the default response format and behavior for webhook endpoints.
    |
    */
    'response' => [
        'include_metadata' => env('WEBHOOK_INCLUDE_METADATA', true),
        'default_per_page' => env('WEBHOOK_DEFAULT_PER_PAGE', 15),
        'max_per_page' => env('WEBHOOK_MAX_PER_PAGE', 100),
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Headers
    |--------------------------------------------------------------------------
    |
    | Additional security headers to include in webhook responses.
    |
    */
    'security_headers' => [
        'X-Content-Type-Options' => 'nosniff',
        'X-Frame-Options' => 'DENY',
        'X-XSS-Protection' => '1; mode=block',
        'Strict-Transport-Security' => 'max-age=31536000; includeSubDomains',
    ],
];
