<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionsModulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permissions_modules', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('customer_id')->nullable(); // Makes the column nullable
            $table->integer('workspace_id')->nullable();
            $table->integer('priority')->nullable()->unique(); // Nullable and unique priority column
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permissions_modules');
    }
}
