<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('projects');
        Schema::dropIfExists('projects_meta');
        Schema::dropIfExists('project_history');
        Schema::dropIfExists('project_sites');
        Schema::dropIfExists('project_documents');
        Schema::dropIfExists('project_document_history');
      
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('client_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('thumbnail')->nullable();
            $table->text('description')->nullable();
            $table->string('address')->nullable();
            $table->string('longitude')->nullable();
            $table->string('latitude')->nullable();
            $table->string('area_radius')->nullable();
            $table->string('state')->nullable();
            $table->integer('active')->default(1);
            $table->integer('is_deleted')->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
        Schema::create('projects_meta', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id');
            $table->text('option');
            $table->string('value')->nullable();
        });
        Schema::create('project_history', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id');
            $table->text('description')->nullable();
            $table->integer('user_id');
            $table->string('history_type')->nullable();
            $table->timestamps();
        });
        Schema::create('project_sites', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id');
            $table->integer('site_id')->nullable();
            $table->integer('user_id');
            $table->timestamps();
        });
        Schema::create('project_documents', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id');
            $table->string('title');
            $table->string('file_name')->nullable();
            $table->string('uploaded_by');
            $table->timestamps();
        });
        Schema::create('project_document_history', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id');
            $table->integer('document_id');
            $table->string('history_type')->nullable();
            $table->text('description')->nullable();
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('projects');
        Schema::dropIfExists('projects_meta');
        Schema::dropIfExists('project_history');
        Schema::dropIfExists('project_sites');
        Schema::dropIfExists('project_documents');
        Schema::dropIfExists('project_document_history');
    }
}
