<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeavePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leave_packages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('leave_type_id');
            $table->integer('leave_number')->nullable();
            $table->integer('is_paid')->nullable();
            $table->string('color_code')->nullable();
            $table->date('renew_on')->nullable();
            $table->text('employee_roles')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leave_packages');
    }
}
