<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTiersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tiers', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        Schema::create('tier_employees', function (Blueprint $table) {
            $table->id();
            $table->integer('tier_id');
            $table->integer('employee_id');
        });
        Schema::create('tier_packages', function (Blueprint $table) {
            $table->id();
            $table->integer('tier_id');
            $table->integer('allowance_package_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tiers');
        Schema::dropIfExists('tier_employees');
        Schema::dropIfExists('tier_packages');
    }
}
