<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whsqe_content_options', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('content_meta_id');
            $table->integer('option_id');
            $table->string('option_value'); // checked, unchecked, selected, etc.
            $table->string('option_type'); // checkbox, radio, select, etc.
            $table->string('option_label')->nullable(); // Human readable label
            $table->string('main_heading')->nullable(); // Main heading for checkbox groups
            $table->integer('group_order')->nullable(); // Order within the group
            $table->enum('level', ['parent', 'child', 'grandchild'])->default('parent'); // Which level this option belongs to
            $table->integer('level_id')->nullable(); // ID of the parent/child/grandchild
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['content_meta_id']);
            $table->index(['customer_id', 'workspace_id']);
            $table->index(['option_id']);
            $table->index(['main_heading']);
            $table->index(['level', 'level_id']);
            
            // Foreign key constraint
            $table->foreign('content_meta_id')->references('id')->on('whsqe_table_of_content_meta')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whsqe_content_options');
    }
}; 