<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentReportedTosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_reported_tos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0); // Set default to 0
            $table->integer('reported_to')->default(0);
            $table->string('company_name')->nullable();
            $table->integer('position')->default(0);
            $table->string('contact_number')->nullable();
            $table->timestamps();
           $table->foreign('incident_report_id')->references('id')->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_reported_tos');
    }
}
