<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentEmployerDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_employer_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->integer('employer_id')->default(0);
            $table->string('employer_name')->nullable();
            $table->string('employer_address')->nullable();
            $table->string('employer_number')->nullable();
            $table->string('supervisor')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('is_employer_worker')->nullable();
            $table->string('is_employer_worker_details')->nullable();
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_employer_details');
    }
}
