<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->string('title')->nullable();
            $table->integer('number')->default(0);
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_documents');
    }
}
