<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInspectionPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inspection_plans', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('itp_reference_number')->nullable();
            $table->string('document_number')->nullable();
            $table->string('authorised_by')->nullable();
            $table->unsignedInteger('site_id')->default(0);
            $table->string('revision_number')->nullable();
            $table->date('revision_date')->nullable();
            $table->date('issue_date')->nullable();
            $table->string('principal_contractor')->nullable();
            $table->string('principal_contractor_email')->nullable();
            $table->string('project_name')->nullable();
            $table->string('job_number')->nullable();
            $table->string('building')->nullable();
            $table->string('level')->nullable();
            $table->string('to_level')->nullable();
            $table->string('zone')->nullable();
            $table->string('pour')->nullable();
            $table->text('description')->nullable();
            $table->string('activity')->nullable();
            $table->date('open_date')->nullable();
            $table->date('close_date')->nullable();
            $table->integer('approval_status')->default(0)->nullable();
            $table->enum('del', ['0', '1'])->default('0');
            $table->enum('process', ['0', '1'])->default('0');
            $table->enum('is_published', ['0', '1'])->default('0');
            $table->unsignedBigInteger('parent_number')->nullable();
            $table->integer('report_method')->default(0);
            $table->integer('send_by')->nullable();
            $table->string('sender_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inspection_plans');
    }
}
