<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInspectionPlanChecklistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inspection_plan_checklists', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('inspection_plan_id')->nullable();
            $table->string('itp_reference_number')->nullable();
            $table->string('itpc_number')->nullable();
            $table->string('name')->nullable();
            $table->text('checklist_note')->nullable();
            $table->enum('status', ['0', '1'])->default('0');
            $table->enum('is_complete', ['0', '1'])->default('0');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();

            $table->timestamps();
            $table->foreign('inspection_plan_id')->references('id')->on('inspection_plans')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inspection_plan_checklists');
    }
}
