<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInspectionPlanMetasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inspection_plan_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('inspection_plan_id')->nullable();
            $table->unsignedBigInteger('itpc_id')->nullable();
            $table->string('title')->nullable();
            $table->string('name')->nullable();
            $table->string('value')->nullable();
            $table->string('is_table')->default(0);
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
            $table->foreign('inspection_plan_id')->references('id')->on('inspection_plans')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('itpc_id')->references('id')->on('inspection_plan_checklists')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inspection_plan_metas');
    }
}
