<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexesToRosterAssignsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('roster_assigns', function (Blueprint $table) {
            //
            $table->index('assign_to'); // Add index on assign_to
            $table->index('roster_template_id'); // Add index on roster_template_id
            $table->index('schedule_date'); // Add index on schedule_date
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('roster_assigns', function (Blueprint $table) {
            //
            $table->dropIndex(['assign_to']); // Drop index on assign_to
            $table->dropIndex(['roster_template_id']); // Drop index on roster_template_id
            $table->dropIndex(['schedule_date']); // Drop index on schedule_date
        });
    }
}
